<?php
session_start();
include 'includes/dbconn.php'; // Ensure this is the path to your DB connection script

// Fetch user details based on company_id from session
$company_id = $_SESSION['company_id'];
$stmt = $conn->prepare("SELECT full_name FROM users WHERE company_id = ?");
$stmt->bind_param("i", $company_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Close the statement
$stmt->close();
?>

<!-- ========== Left Sidebar Start ========== -->
<div class="left-side-menu">

    <div class="h-100" data-simplebar>

         <!-- User box -->
        <div class="user-box text-center">

            <img src="assets/images/users/user-1.jpg" alt="user-img" title="Mat Helme" class="rounded-circle img-thumbnail avatar-md">
                <div class="dropdown">
                    <a href="#" class="user-name dropdown-toggle h5 mt-2 mb-1 d-block" data-bs-toggle="dropdown" aria-expanded="false">
                        <?php echo htmlspecialchars($user['full_name']); ?>
                    </a>
                    <div class="dropdown-menu user-pro-dropdown">

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-user me-1"></i>
                            <span>My Account</span>
                        </a>
        
                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-settings me-1"></i>
                            <span>Settings</span>
                        </a>
        
                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item notify-item">
                            <i class="fe-lock me-1"></i>
                            <span>Lock Screen</span>
                        </a>
        
                        <!-- item-->
                        <a href="auth-logout.php" class="dropdown-item notify-item">
                            <i class="fe-log-out"></i>
                            <span>Logout</span>
                        </a>
        
                    </div>
                </div>

            <p class="text-muted left-user-info">System Admin</p>

            <ul class="list-inline">
                <li class="list-inline-item">
                    <a href="#" class="text-muted left-user-info">
                        <i class="mdi mdi-cog"></i>
                    </a>
                </li>

                <li class="list-inline-item">
                    <a href="auth-logout.php">
                        <i class="mdi mdi-power"></i>
                    </a>
                </li>
            </ul>
        </div>

        <!--- Sidemenu -->
        <div id="sidebar-menu">

            <ul id="side-menu">

                <li class="menu-title">Navigation</li>
                
                <li>
                    <a href="index.php">
                        <i class="mdi mdi-view-dashboard-outline"></i>
                        <span> Dashboard </span>
                    </a>
                </li>

                <li class="menu-title mt-2">Finances</li>

                <li>
                    <a href="#transactions" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Transactions </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="transactions">
                        <ul class="nav-second-level">
                            <li>
                                <a href="create_transaction.php">Record Transactions</a>
                            </li>
                            <li>
                                <a href="#">Bank Reconciliation</a>
                            </li>
                            <li>
                                <a href="#">Journal</a>
                            </li>
                            <li>
                                <a href="#">Transaction Uploads & Management</a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                <li>
                    <a href="#invoices" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Invoicing </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="invoices">
                        <ul class="nav-second-level">
                            <li>
                                <a href="create_invoice.php">Create Invoices</a>
                            </li>
                            <li>
                                <a href="list_invoices.php">Invoice History</a>
                            </li>
                            <li>
                                <a href="#">Payment Reminders</a>
                            </li>
                        </ul>
                    </div>
                </li>
                
                <li>
                    <a href="#expenses" data-bs-toggle="collapse">
                        <i class="mdi mdi-clipboard-outline"></i>
                        <span> Expenses </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="expenses">
                        <ul class="nav-second-level">
                            <li>
                                <a href="add_expense.php">Create Expenses</a>
                            </li>
                            <li>
                                <a href="expense_category.php">Expense Categories</a>
                            </li>
                            <li>
                                <a href="#">Expense Reports</a>
                            </li>
                            <li>
                                <a href="#">Receipt Uploads & Management</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="menu-title mt-2">Budgets, Payroll & Taxes</li>

                <li>
                    <a href="#budgets" data-bs-toggle="collapse">
                        <i class="mdi mdi-book-open-page-variant-outline"></i>
                        <span> Budgeting </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="budgets">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Create Budgets</a>
                            </li>
                            <li>
                                <a href="#">Budget vs. Actual</a>
                            </li>
                            <li>
                                <a href="#">Forecasting & Planning</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li>
                    <a href="#payroll" data-bs-toggle="collapse">
                        <i class="mdi mdi-file-multiple-outline"></i>
                        <span> Payroll </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="payroll">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Employee Management</a>
                            </li>
                            <li>
                                <a href="#">Payroll Processing</a>
                            </li>
                         </ul>
                    </div>
                </li>

                <li>
                    <a href="#taxes" data-bs-toggle="collapse">
                        <i class="mdi mdi-dock-window"></i>
                        <span> Taxation </span>
                        <span class="menu-arrow"></span>

                    </a>
                    <div class="collapse" id="taxes">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Tax Filing</a>
                            </li> 
                            <li>
                                <a href="#">Tax Calculations</a>
                            </li>
                            <li>
                                <a href="#">Tax Document Generation</a>
                            </li>
                            <li>
                                <a href="#">Tax Withholding & Reporting</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li class="menu-title mt-2">Banking & Reconciliation</li>

                <li>
                    <a href="#banking" data-bs-toggle="collapse">
                        <i class="mdi mdi-briefcase-outline"></i>
                        <span> Banking </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="banking">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Bank Account Mngt</a>
                            </li>
                            <li>
                                <a href="#">Reconciliation</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li>
                    <a href="#assets" data-bs-toggle="collapse">
                        <i class="mdi mdi-layers-outline"></i>
                        <span> Assets & Depreciation </span>
                    </a>
                    <div class="collapse" id="assets">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Asset Management & Tracking</a>
                            </li>
                            <li>
                                <a href="#">Depreciation Calculations</a>
                            </li>
                            <li>
                                <a href="#">Asset Disposal & Retirement</a>
                            </li>
                        </ul>
                    </div>
                </li>

                
                <li class="menu-title mt-2">User Management</li>
                    
                <li>
                    <a href="#users" data-bs-toggle="collapse">
                        <i class="mdi mdi-account-multiple-plus-outline"></i>
                        <span> Users & Clients </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="users">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">User Management</a>
                            </li>
                            <li>
                                <a href="all_clients.php">Client Management</a>
                            </li>
                            <li>
                                <a href="#">User Logs</a>
                            </li>
                        </ul>
                    </div>
                </li>
                

                <li class="menu-title mt-2">Reporting</li>
                
                <li>
                    <a href="#reports" data-bs-toggle="collapse">
                        <i class="mdi mdi-chart-donut-variant"></i>
                        <span> Financial Statements </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="reports">
                        <ul class="nav-second-level">
                            <li>
                                <a href="coa.php">Chart of Accounts</a>
                            </li>
                            <li>
                                <a href="#">Profit & Loss</a>
                            </li>
                            <li>
                                <a href="#">Balance Sheet</a>
                            </li>
                            <li>
                                <a href="trial_balance.php">Trial Balance</a>
                            </li>
                            <li>
                                <a href="income_statement.php">Income Statement</a>
                            </li>
                        </ul>
                    </div>
                </li>

                <li>
                    <a href="#tax-reports" data-bs-toggle="collapse">
                        <i class="mdi mdi-map-outline"></i>
                        <span> Taxes </span>
                        <span class="menu-arrow"></span>
                    </a>
                    <div class="collapse" id="tax-reports">
                        <ul class="nav-second-level">
                            <li>
                                <a href="#">Tax Reports</a>
                            </li>
                            <li>
                                <a href="#">Tax Documents</a>
                            </li>
                        </ul>
                    </div>
                </li>

                
            </ul>

        </div>
        <!-- End Sidebar -->

        <div class="clearfix"></div>

    </div>
    <!-- Sidebar -left -->

</div>
<!-- Left Sidebar End -->